<?php include PATH_VIEW.'/layout/header.tpl'; ?>

<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">
		
		<div class="row">

			<div class="col-md-8">
				<section id="column1" class="mb-4">
					<h1 class="title-page"><?php echo $header_title; ?></h1>
					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW.'/layout/breadcrumb.tpl' ?>
					</section>
					<?php if($itemList) { ?>
						<div class="row">
						<?php foreach($itemList as $item){ ?>
							<article class="col-md-4 col-sm-6 col-6">
								<div class="card post1-card text-bg-dark" >
									<a class="link-post" href="<?php echo PATH_SYSTEM."photos/view/".$item->postId.'-'.$item->postUrl; ?>" aria-label="<?php echo $item->title; ?>"></a>
									<img loading="lazy" src="<?php echo PATH_SYSTEM."public/album/".$item->thumbnail; ?>" class="card-img" alt="<?php echo $item->title; ?>">
									<div class="card-img-overlay d-flex flex-column">
										<h3 class="card-title mb-auto"><?php echo $item->title; ?></h3>
										<p class="card-text"><small><?php echo FormatDate($setting->format_date, $item->date_post); ?></small></p>
									</div>
									<span class="button"><i class="fas fa-camera"></i></span>
								</div>
							</article>
						<?php } ?>
						</div>

						<?php echo pagination($pathPage, $countList, $perPage, $currentPage, $queryStringArray); ?>

					<?php }else{ ?>
						<div class="alert alert-danger" role="alert">
							<?php echo $_LANG['empty'] ?>
						</div>
					<?php } ?>
					
				</section>
			</div>

			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php 
							// widgets column 2
							include PATH_VIEW.'/layout/search.tpl';
							include PATH_VIEW.'/layout/category.tpl';

							$widgetPos = 4;
							include PATH_VIEW.'/layout/widget.tpl';
						?>
					</section>
				</aside>
			</div>


		</div>
		
	</div>
</div>

<?php include PATH_VIEW.'/layout/footer.tpl'; ?>